import math

N, dozvoljena_težina, eps = input().split()
N = int(N)
dozvoljena_težina = int(dozvoljena_težina)
eps = float(eps)

items = []
for i in range(N):
    težina, vrednost = map(int, input().split())
    items.append((težina, vrednost, i + 1))

max_vrednost = max(vrednost for _, vrednost, _ in items)

if max_vrednost == 0:
    print(0)
    print()
    exit()

K = eps * max_vrednost / N

scaled = []
for težina, vrednost, idx in items:
    scaled.append((težina, int(vrednost // K), vrednost, idx))

S = sum(vrednosti for _, vrednosti, _, _ in scaled)

INF = 10**30
dp = [INF] * (S + 1)
dp[0] = 0

izbor = [[False] * (S + 1) for _ in range(N)]

for i in range(N):
    težina, vrednosti, _, _ = scaled[i]
    for s in range(S, vrednosti - 1, -1):
        if dp[s - vrednosti] + težina < dp[s]:
            dp[s] = dp[s - vrednosti] + težina
            izbor[i][s] = True

best_s = 0
for s in range(S + 1):
    if dp[s] <= dozvoljena_težina and s > best_s:
        best_s = s

rešenje = []
s = best_s
for i in range(N - 1, -1, -1):
    if izbor[i][s]:
        težina, vrednosti, _, idx = scaled[i]
        rešenje.append(idx)
        s -= vrednosti

print(len(rešenje))
print(*rešenje)